/*
 * @file aud-dbus-connector.h
 * This file provides the declaration of the classes which handle asynchronous communication with dbus.
 * If asynchronous communication is required, then libdbus requires you to implement dbus_watch and dbus_timer
 *  Created on: Mar 9, 2016
 *
 * @author rjk2kor
 *
 * \copyright RBEI
 */

#ifndef AUD_DBUS_CONNECTOR_H_
#define AUD_DBUS_CONNECTOR_H_

#include <dbus/dbus.h>
#include "CAmSocketHandler.h"


class aud_ml_dbus_watch_connector
{
private:
  //Explicit privates
  aud_ml_dbus_watch_connector();
  aud_ml_dbus_watch_connector(const aud_ml_dbus_watch_connector&);
private:
  am::CAmSocketHandler*              m_poMainLoop;//Pointer to mainloop
  DBusConnection*                 m_poConnection;//Pointer to dbus connection object
  /**
   * Functions called by libdbus
   */
  static dbus_bool_t  bAdd            (DBusWatch    *watch,   void* pvUserData);
  static void      vRemove            (DBusWatch   *watch,   void* pvUserData);
  static void      vToggle            (DBusWatch   *watch,   void* pvUserData);

public:
  aud_ml_dbus_watch_connector(DBusConnection* x, am::CAmSocketHandler* y);
  virtual ~aud_ml_dbus_watch_connector();

private:
  /**
   * Cannot inherit from all the classes at the same time due to similar signatures
   * As a workaround using objects and passing their pointers
   */
  /**
   * The following functions would be invoked by the mainloop of genivi audio manager
   */
  am::TAmShPollCheck<aud_ml_dbus_watch_connector>     m_oCheck;    //Object which encapsulates the callback function from GAM mainloop
  bool bCheck    (const am::sh_pollHandle_t handle, void* pvuserdata);

    am::TAmShPollFired<aud_ml_dbus_watch_connector>     m_oFire;     //Object which encapsulates the callback function from GAM mainloop
    void vFire    (const pollfd, const am::sh_pollHandle_t handle, void* pvuserdata);

    am::TAmShPollDispatch<aud_ml_dbus_watch_connector>     m_oDispatch;  //Object which encapsulates the callback function from GAM mainloop
  bool bDispatch  (const am::sh_pollHandle_t handle, void* pvuserdata);
};

class aud_ml_dbus_timer_connector:public am::IAmShTimerCallBack
{
private:
  //Explicit privates
  aud_ml_dbus_timer_connector();
  aud_ml_dbus_timer_connector(const aud_ml_dbus_timer_connector&);
private:
  am::CAmSocketHandler*              m_poMainLoop;
  static dbus_bool_t  bAdd            (DBusTimeout *timeout, void* pvUserData);
  static void      vRemove            (DBusTimeout *timeout, void* pvUserData);
  static void      vToggle            (DBusTimeout *timeout, void* pvUserData);
public:
  aud_ml_dbus_timer_connector(DBusConnection* x, am::CAmSocketHandler* y);
  virtual ~aud_ml_dbus_timer_connector();
  virtual void Call(const am::sh_timerHandle_t handle, void* userdata);
};


#endif /* AUD_DBUS_CONNECTOR_H_ */
